/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.msgsvc;

import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.FcsEventListener;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.system.Manager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.msgsvc.FcsEntity;
import com.ibm.hwmca.fw.util.msgsvc.Message;
import com.ibm.hwmca.fw.util.msgsvc.MessageId;
import com.ibm.hwmca.fw.util.msgsvc.MessageService;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntity;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntityStateEvent;
import com.ibm.hwmca.fw.util.msgsvc.RemoteMsgSvcSupporter;
import java.io.BufferedInputStream;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FcsSupporter
implements RemoteMsgSvcSupporter,
FcsService,
FcsEventListener {
    private static final String TRACE_MASKT = "XMSGFS T";
    private static final String TRACE_MASKF = "XMSGFS F";
    private static final String TRACE_MASKD = "XMSGFS D";
    protected static final String CLASS_NAME = "com.ibm.hwmca.fw.util.msgsvc.FcsSupporter";
    protected static final double CLASS_VERSION = 1.0;

    public FcsSupporter() {
        FcsServiceId svcid = new FcsServiceId("com.ibm.hwmca.fw.util.msgsvc.FcsSupporter-I'm alive", 1.0);
        Trace.trace(TRACE_MASKD, "ctor: need to block until BaseTower is up...");
        Manager.getManager().waitForTowers();
        Trace.trace(TRACE_MASKD, "ctor: ...BaseTower is up - finish ctor");
        try {
            FcsServer.getFcsServer().addLocalService(svcid, this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FcsServer.getFcsServer().addFcsEventListener(this);
    }

    public String getPartitionId() {
        return "fcs";
    }

    public void beginAccepting(Set msgidSet) {
        Trace.trace(TRACE_MASKD, "--> beginAccepting");
        Iterator setIter = msgidSet.iterator();
        while (setIter.hasNext()) {
            MessageId msgid = (MessageId)setIter.next();
            Trace.trace(TRACE_MASKD, "msgid:" + msgid.getId());
            FcsServiceId svcid = new FcsServiceId("com.ibm.hwmca.fw.util.msgsvc.FcsSupporter-" + msgid.getId(), 1.0);
            try {
                FcsServer.getFcsServer().addLocalService(svcid, this);
            }
            catch (IllegalArgumentException e) {}
        }
        Trace.trace(TRACE_MASKD, "<-- beginAccepting");
    }

    public void stopAccepting(Set msgidSet) {
        Trace.trace(TRACE_MASKD, "--> stopAccepting");
        Iterator setIter = msgidSet.iterator();
        while (setIter.hasNext()) {
            MessageId msgid = (MessageId)setIter.next();
            Trace.trace(TRACE_MASKD, "msgid:" + msgid.getId());
            FcsServiceId svcid = new FcsServiceId("com.ibm.hwmca.fw.util.msgsvc.FcsSupporter-" + msgid.getId(), 1.0);
            try {
                FcsServer.getFcsServer().removeLocalService(svcid);
            }
            catch (IllegalArgumentException e) {}
        }
        Trace.trace(TRACE_MASKD, "<-- stopAccepting");
    }

    public Set getAcceptingTargets(MessageId msgid) {
        Trace.trace(TRACE_MASKD, "--> getAcceptingTargets: msgid:" + msgid.getId());
        FcsServiceId svcid = new FcsServiceId("com.ibm.hwmca.fw.util.msgsvc.FcsSupporter-" + msgid.getId(), 1.0);
        Set machidSet = FcsServer.getFcsServer().getSupportingMachines(svcid);
        MachineId localid = FcsServer.getFcsServer().getLocalMachineId();
        HashSet<FcsEntity> entitySet = new HashSet<FcsEntity>();
        Iterator machidIter = machidSet.iterator();
        MachineId machid = null;
        while (machidIter.hasNext()) {
            machid = (MachineId)machidIter.next();
            if (machid == localid) continue;
            entitySet.add(new FcsEntity(machid));
        }
        Trace.trace(TRACE_MASKD, "<-- getAcceptingTargets");
        return entitySet;
    }

    public boolean isAcceptableTarget(RemoteEntity target) {
        Class<?> entityClass = null;
        try {
            entityClass = Class.forName("com.ibm.hwmca.fw.util.msgsvc.FcsEntity");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKD, "<-> isAcceptableTarget: comparing " + target.getClass() + ":acceptable:" + entityClass.isAssignableFrom(target.getClass()));
        return entityClass.isAssignableFrom(target.getClass());
    }

    public void fcsStateChanged(FcsEvent event) {
        int evtType = event.getEventType();
        int evtDetails = event.getEventDetails();
        Trace.trace(TRACE_MASKD, "--> fcsStateChanged: evtType=" + evtType + ",evtDetails=" + evtDetails);
        if (evtType == 1 && evtDetails == 51) {
            Trace.trace(TRACE_MASKD, "machine added");
            this.processEvent(event, "Add");
        } else if (evtType == 2 && evtDetails == 100) {
            Trace.trace(TRACE_MASKD, "svc added");
            this.processEvent(event, "Add");
        } else if (evtType == 1 && evtDetails == 52) {
            Trace.trace(TRACE_MASKD, "machine removed");
            this.processEvent(event, "Remove");
        } else if (evtType == 2 && evtDetails == 101) {
            Trace.trace(TRACE_MASKD, "svc removed");
            this.processEvent(event, "Remove");
        }
        Trace.trace(TRACE_MASKD, "<-- fcsStateChanged");
    }

    protected void processEvent(FcsEvent event, String stateToFire) {
        Set svcSet = event.getServices();
        if (svcSet == null) {
            Trace.trace(TRACE_MASKD, "no services in event");
            return;
        }
        Iterator svcIter = svcSet.iterator();
        FcsServiceId machFsi = null;
        while (svcIter.hasNext()) {
            machFsi = (FcsServiceId)svcIter.next();
            if (!machFsi.getServiceName().startsWith(CLASS_NAME)) continue;
            RemoteEntityStateEvent resEvent = new RemoteEntityStateEvent(stateToFire, new FcsEntity(event.getMachineId()), new MessageId(machFsi.getServiceName().substring(CLASS_NAME.length() + 1)));
            MessageService.getMessageService().remoteEntityStateChanged(resEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processConnection(FcsConnection connection) {
        block13: {
            Trace.trace("XMSGFS D", "--> processConnection");
            s = null;
            try {
                block12: {
                    s = connection.getSocket();
                    in = new ObjectInputStream(new BufferedInputStream(s.getInputStream()));
                    msg = (Message)in.readObject();
                    s.close();
                    if (msg != null) {
                        Trace.trace("XMSGFS D", "recd msg (id=" + msg.getMessageId().getId() + ")");
                        sender = new FcsEntity(connection.getMachineId());
                        MessageService.getMessageService().deliverFromRemote(msg, sender);
                        break block12;
                    }
                    Trace.trace("XMSGFS D", "null msg");
                }
                var7_7 = null;
                ** if (s == null || s.isClosed()) goto lbl-1000
            }
            catch (Throwable var6_13) {
                var7_9 = null;
                if (s != null && !s.isClosed()) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw var6_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    s.close();
                }
                catch (Exception e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block13;
                catch (Exception e) {
                    Trace.trace("XMSGFS T", "Error processing remote connection:");
                    Trace.trace("XMSGFS T", e);
                    var7_8 = null;
                    if (s != null && !s.isClosed()) {
                        try {
                            s.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        Trace.trace("XMSGFS D", "<-- processConnection");
    }
}

